require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );
require( "scripts/pin.lua" );
require( "scripts/paths.lua" );

local wm_closed = false;

function FadeComplete()
    if(GetCurrentGameMode() == 0) then
        CheckIntro();
        
        --check location transitions
        local level = GetCurrentLevel();
        if(GetManagedInt("do_map_transition",0) == 1) then
            SetManagedValue("do_map_transition", 0, false);
            if(level == 11) then
                PlayTransition( "grytviken" );
            elseif(level == 21) then
                PlayTransition( "namche" );
            elseif(level == 31) then
                PlayTransition( "krakatoa" );
            elseif(level == 41) then
                PlayTransition( "kamchatka" );
            elseif(level == 51) then
                PlayTransition( "gaberoun" );
            else
                ShowCurrentLocation();
            end
        else
            ShowCurrentLocation();
        end
    end
end

function CheckIntro()
	if(GetManagedInt("game_intro", 0) == 0) then
	    SetManagedValue("game_intro", 1, true);
		DoModal( "scripts/intro.lua" );	
	end	
end

function CloseMapWindow()
    DisplayDialog { "scripts/loading.lua", isFirst = false };
    CloseWindow();
end

function CloseWorldMap(loadGame)
    local doClose = true;
    if( GetCurrentGameMode() ~= 0 ) then
        diff = DisplayDialog{"scripts/choosedifficulty.lua"};
        if(diff >= 0) then
            SetCurrentDifficulty( diff );
        else
            doClose = false;
        end
    end
    if(doClose and not wm_closed) then
        wm_closed = true;
	    if(IsGameLoaded()) then
		    DoTransition( kFadeToBlack );
		    CloseMapWindow();
	    else
	        DoTransition( kFadeToBlack );
	        SwapToModal( 'scripts/game.lua' ); 
	        DisplayDialog { 'scripts/loading.lua', isFirst = true };
	    end
	    SetState("MetaMapScreenTime", 0);
    end
end


MakeDialog
{
	name = "worldmap",
	
	Bitmap{
		x = 0,
		y = 0,
		image = "ui/backgrounds/worldmap",
		------------------------------------------------Button Trim pieces
		Bitmap{
		    x = 24,
		    y = 476,
		    image = "ui/buttons/button_trim_2",
		    mask = "ui/buttons/button_trim_2.mask",
		},
		Bitmap{
		    x = 651,
		    y = 476,
		    hflip = true,
		    image = "ui/buttons/button_trim_2",
		    mask = "ui/buttons/button_trim_2.mask",
		},
		Bitmap{
		    x = 249,
		    y = 533,
		    image = "ui/buttons/button_trim",
		    mask = "ui/buttons/button_trim.mask",
		},
		Bitmap{
		    x = 468,
		    y = 533,
		    hflip = true,
		    image = "ui/buttons/button_trim",
		    mask = "ui/buttons/button_trim.mask",
		},
		------------------------------------------------Header gem
		Bitmap{
		    --x = 5,
		    name = "worldmap_gem",
		    image = "ui/map/gem_story",
		},
		
		--shadow
		Text{
		    name = "worldmap_header_shadow",
			x = 3, y = 57,
			w = kMax, h = 75,
			flags = kVAlignCenter + kHAlignCenter,
			font = 	{edwardian_medium, 38, ShadowColor },
			label = "map_header",
		},
		--title
		Text{
		    name = "worldmap_header",
			x = 0, y = 54,
			w = kMax, h = 75,
			flags = kVAlignCenter + kHAlignCenter,
			font = 	{edwardian_medium, 38, Color(243, 226, 196) },
			label = "#<outline color='545050' size='1'>"..GetString('map_header').."</outline>",
		},

		----------------------------------------------- Main Menu and OK buttons
		SetStyle(CSMMRight2ButtonStyle),
		Button{
			x = 20, y = 476, 
			hflip = true,
			Window
			{
				x = 0, y = 0, w = kMax, h = kMax-30,
				Text{
					x = 0, y = 0,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignCenter,
					font = {edwardian_medium, 22, WhiteColor},
					label = "btn_main",
				},
				Text{
					x = 18, y = 35,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignCenter,
					font = {edwardian_medium, 22, WhiteColor},
					label = "btn_menu",
				},
			},
			command = 
				function()
				    SetState("MetaMapScreenTime", 0);
				    --if( not wm_closed ) then
				        --wm_closed = true;
				        DoTransition( kFadeToBlack );
				        QuitToMainMenu();
					--end
				end
		},
		SetStyle(CSMMRight2ButtonStyle),
		Button{
		    name = "btn_play",
			x = 656, y = 474,
			Text{
				w = kMax-10, h = kMax-10,
				flags = kHAlignCenter + kVAlignCenter,
				font = {edwardian_medium, 28, WhiteColor},
				label = "map_play",
			},
			command = 
				function()
				    if(GetConfig("firstpeek") == "1" and GetHighestComplete() >= 20) then
				       SetCurrentLevel(20);
				    elseif(GetHighestComplete() == 60) then
				       SetCurrentLevel(60);
				    else
				        SetCurrentLevel(GetHighestComplete() + 1);
				    end
				    --if( not wm_closed )then
				        --wm_closed =  true;
				        CloseWorldMap();
				    --end
				end
		},
		----------------------------------sweet rewards for endless mode (replaces play button)
		Button{
		    name = "btn_rewards_endless",
			x = 656, y = 474,
			Window
			{
				x = 0, y = 0, w = kMax-20, h = kMax-30,
				Text{
					x = 18, y = 0,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignCenter,
					font = {edwardian_medium, 22, WhiteColor},
					label = "mainmenu_sweet",
				},
				Text{
					x = 3, y = 35,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignCenter,
					font = {edwardian_medium, 19, WhiteColor},
					label = "mainmenu_rewards",
				},
			},
			command = 
				function()
				   SetState("MetaMapScreenTime", 0);
				   DoTransition( kFadeToBlack );
				   DisplayDialog{ 'scripts/rewardswindow.lua', context='worldmap' };
				end
		},
		----------------------------------sweet rewards
		SetStyle(CSMMOvalButtonStyle),
		Button{
		    name = "btn_rewards",
			x = 295,
			y = 530,
			Window
			{
				x = 0, y = 0, w = kMax, h = kMax,
				Text{
					x = 0, y = 19,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignTop,
					font = {edwardian_medium, 17, WhiteColor},
					label = "mainmenu_sweet",
				},
				Text{
					x = 0, y = 32,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignTop,
					font = {edwardian_medium, 17, WhiteColor},
					label = "mainmenu_rewards",
				},
			},
			command = 
				function()
				    SetState("MetaMapScreenTime", 0);
				    DoTransition( kFadeToBlack );
				    DisplayDialog{ 'scripts/rewardswindow.lua', context='worldmap' };
				end
		},
		----------------------------------options
		Button{
		    name = "btn_options",
			x = 391,
			y = 530,
			Text{
				x = 0, y = 0,
				w = kMax, h = kMax - 10,
				flags = kHAlignCenter + kVAlignCenter,
				font = {edwardian_medium, 20, WhiteColor},
				label = "mainmenu_options",
			},
			command = 
				function()
					DoModal('scripts/options.lua');
				end
		},
		
		SetStyle(CSMainMenuButton),
		Button{
			name = "game_cheats",
			x = 5, y = 5,
			label = "#Cheats",
			flags = kVAlignCenter + kHAlignCenter,
			command = 
				function()
				    SetState("MetaMapScreenTime", 0);
					DisplayDialog { "scripts/cheats.lua", context = "map" };
					SetState("MetaMapScreenTime", 1);
				end,
		},
		
		VWorldMap{
		    name = "world_map_window",
		    x = 0, y = 0, w = kMax, h = kMax,
		    pins = map_pins,
		    paths = map_paths,
		    dot = {
		        baseDir = "ui/map/",
		        assets = {
		            dot = {
		                {state = "green", file = "dot_green", anim = false},
		                {state = "blue", file = "dot_blue", anim = false},
		            },
		        },
		    },
		}
	},
}

---------------- 
--	Always fade from black and check if we need a game intro popup

PostMessage( CreateNamedMessage( kFadeFromBlack, "FadeComplete();" ) );

EnableWindow("game_cheats", IsEnabled(kCheatMode));
EnableWindow("btn_play", GetCurrentGameMode() == 0);
EnableWindow("btn_rewards", GetCurrentGameMode() == 0);
EnableWindow("btn_rewards_endless", GetCurrentGameMode() ~= 0);
if(not (GetCurrentGameMode() == 0)) then
    SetBitmap("worldmap_gem", "ui/map/gem_endless", 1.0);
    SetLabel("worldmap_header", "<outline color='545050' size='1'>"..GetString("map_header_endless").."</outline>");
    SetLabel("worldmap_header_shadow", GetString("map_header_endless"));
end
--METRICS
SetState("MetaMapScreenTime", 1);